<html lang="es-CL">
    <head>
        <title>Radio La Sabrosita FM</title>     
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
        <meta name="viewport" content="initial-scale=0.8 maximum-scale=1.0, user-scalable=yes" />
        <meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate" />
        <meta http-equiv="Pragma" content="no-cache" />
        <meta http-equiv="Expires" content="0" />
        <link rel="canonical" href="https://lasabrositafm.cl">
        <meta name="description" content="Sabrosita FM">
        <meta property="og:url" content="https://lasabrositafm.cl">
        <meta property="og:title" content="Sabrosita FM">
        <meta property="og:site_name" content="Red de emisoras La Sabrosita FM">
        <meta property="og:description" content="Red de emisoras La Sabrosita FM">
        <!--Tags para Twitter-->
        <meta name="twitter:title" content="Sabrosita FM" />
        <meta name="twitter:url" content="https://lasabrositafm.cl">
        
        <meta name="DC.Title" lang="es" content="Sabrosita FM">
        <meta name="DC.Description" lang="es" content="Sabrosita FM">
        <meta name="DC.Author" content="Sabrosita FM">
        <meta name="DC.Creator" content="Sabrosita FM">
        <meta name="DC.Language" scheme="RFC1766" content="es">
        <meta name="DC.format" scheme="IMT" content="text/html"> 
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
        <?php 
            $isMob = is_numeric(strpos(strtolower($_SERVER["HTTP_USER_AGENT"]), "mobile")); 
 
            if($isMob){ 
                echo '<style>
                        .logo {
                        width: 90%;
                        height: auto;
                    }</style>'; 
            }
            
        ?>
        <style>
            p { margin:2 }
            select {
                appearance: none;
                outline: none;
                cursor: pointer;

                color: #fddd00;
                background-color: #ff1117;
                border: 2px solid #fddd00;

                border-radius: 5px;
                padding: 5px 10px;
                width: 290px;
                height: 55px;

                font-family: serif;
                font-size: 20px;
                font-weight: bold;
                text-align: center;
                
                background-image:
                    linear-gradient(45deg, transparent 50%, #fddd00 50%),
                    linear-gradient(135deg, #fddd00 50%, transparent 50%),
                    linear-gradient(to right, transparent, transparent);
                background-position:
                    calc(100% - 20px) calc(1em + 2px),
                    calc(100% - 15px) calc(1em + 2px),
                    100% 0;
                background-size:
                    5px 5px,
                    5px 5px,
                    2.5em 2.5em;
                background-repeat: no-repeat;                
            }

            select:focus {
                outline: 2px dashed blue;
            }
            
            .icon-bar {
                position: fixed;
                top: 50%;
                -webkit-transform: translateY(-50%);
                -ms-transform: translateY(-50%);
                transform: translateY(-50%);
            }

            .icon-bar a {
                display: block;
                text-align: center;
                padding: 16px;
                transition: all 0.3s ease;
                color: white;
                font-size: 20px;
            }

            .icon-bar a:hover {
                background-color: #000;
            }

            .facebook {
                background: #3B5998;
                color: white;
            }

            .instagram {
                /*background: #883db4;*/
                background: #f09433; 
                background: -moz-linear-gradient(45deg, #f09433 0%, #e6683c 25%, #dc2743 50%, #cc2366 75%, #bc1888 100%); 
                background: -webkit-linear-gradient(45deg, #f09433 0%,#e6683c 25%,#dc2743 50%,#cc2366 75%,#bc1888 100%); 
                background: linear-gradient(45deg, #f09433 0%,#e6683c 25%,#dc2743 50%,#cc2366 75%,#bc1888 100%); 
                filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#f09433', endColorstr='#bc1888',GradientType=1 );
                color: white;
            }

            .google {
                background: #dd4b39;
                color: white;
            }

            .linkedin {
                background: #007bb5;
                color: white;
            }

            .youtube {
                background: #bb0000;
                color: white;
            }
            
            .div-player {
                border-radius: 25px;
                border: 2px solid #ff1117;
                padding: 3px;
                width: 300px;
                height: 185px;
            }            
        </style>
    </head>
    <body>
        
        <div class="icon-bar">
            <a href="https://www.facebook.com/lasabrositachile" class="facebook" target="_blank"><i class="fa fa-facebook"></i></a> 
            <a href="https://www.instagram.com/radiolasabrosita_chile/" class="instagram" target="_blank"><i class="fa fa-instagram"></i></a> 
            <!--<a href="#" class="google"><i class="fa fa-google"></i></a> -->
            <!--<a href="#" class="linkedin"><i class="fa fa-linkedin"></i></a>-->
            <!--<a href="#" class="youtube"><i class="fa fa-youtube"></i></a> -->
        </div>

        <center>
        <img class="logo" src="img/logo_base.png">
        <br>
        <div class="div-player">
            <h1 style="font-family:Tahoma;font-size:20px;">Elige tu Señal!</h1>
            <!--Boton De Play/Stop-->
            <img src="img/btn_play.png" id="ControlToggle" onclick="toggleControl();" alt="Control Reproductor" style="width:60px;height:60px;"/>
            <!--Boton de Mute/UnMute-->
            <img src="img/btn_soundoff.png" id="ControlMute" onclick="toggleMute();" alt="Mute Reproductor" style="width:60px;height:60px;"/>
            <br>
            <select id="combo_radios" onchange="change()">
                <option value="https://audio.streaminghd.cl:9234/stream/2/">Concepción</option>
                <option value="https://audio.streaminghd.cl:9234/stream/3/">Los Angeles</option>
                <option value="https://audio.streaminghd.cl:9234/stream/3/">Santa Bárbara</option>
                <option value="https://audio.streaminghd.cl:9234/stream/4/">Los lagos</option>
                <option value="https://audio.streaminghd.cl:9234/stream/5/">Lanco</option>
                <option selected value="https://audio.streaminghd.cl:9234/stream/1/">Osorno</option>
                <option value="https://audio.streaminghd.cl:9234/stream/1/">Río Negro</option>
                <option value="https://audio.streaminghd.cl:9234/stream/6/">Bahía Mansa</option>
                <option value="https://audio.streaminghd.cl:9234/stream/7/">Entre Lagos</option>
                <option value="https://audio.streaminghd.cl:9234/stream/8/">Los Muermos</option>
                <option value="https://audio.streaminghd.cl:9234/stream/9/">Punta Arenas</option>
                <option value="https://audio.streaminghd.cl:9234/stream/10/">Puerto Natales</option>
                <option value="https://audio.streaminghd.cl:9234/stream/11/">Puerto Varas</option>
            </select>   
            <br>
            <audio hidden id="reproductor" name="media" preload="none">
                <source id="url" src="#">
                Tu navegador no soporta el player.
            </audio>        
        </div>
        <script>
            function change() {
                var audio = document.getElementById("reproductor");

                if (SetUrl()) {
                    audio.pause();
                    toggleControl();
                }
            }
            
            function toggleControl() {
                var audio = document.getElementById("reproductor");

                var img1 = "btn_play.png";
                var img2 = "btn_stop.png";
                const str1 = 'img/';
           
                var imgElement = document.getElementById('ControlToggle');

                if (audio.paused) {
                    imgElement.src = str1.concat(img2);
                    audio.load();
                    audio.play();
                    console.log("Play");
                } else {
                    imgElement.src = str1.concat(img1);
                    audio.pause();
                    console.log("Pause");
                }
            }    
                
            function toggleMute() {
                var audio = document.getElementById("reproductor");
                var img1 = "btn_soundon.png";
                var img2 = "btn_soundoff.png";
                const str1 = 'img/';
           
                var imgElement = document.getElementById('ControlMute');

                if (audio.muted) {
                    imgElement.src = str1.concat(img2);
                    audio.muted = false;
                    console.log("Mute");
                } else {
                    imgElement.src = str1.concat(img1);
                    audio.muted = true;
                    console.log("Un-Mute");
                }                
            } 
            
            function SetUrl() {
                var sourceUrl = document.getElementById("combo_radios").value;
                var source = document.getElementById("url");
    
                if (sourceUrl) {
                    source.src = sourceUrl;
                    console.log("Cambiado a: " + sourceUrl);
                    return true;
                    
                }
                return false;
            }
            
            window.onload = SetUrl;
            
        </script>
        <div>
            <br>
            <!--Descargas App-->
            <a href="https://play.google.com/store/apps/details?id=com.creativoagencia.lasabrositafm" target="_blank"><img class="app" src="img/app_android.png" alt="APP Sabrosita Android" style="width:300px;height:90px;"></a>
            <br>
            <br>
            <a href="https://apps.apple.com/cl/app/radio-la-sabrosita-chile/id6451073290" target="_blank"><img class="app" src="img/app_ios.png" alt="APP Sabrosita IOS" style="width:300px;height:90px;"></a>
            <br><br>
        </div>
        <div>
            <!--Contacto-->
            <a href="https://wa.me/56933256102" target="_blank"><img class="app" src="img/wsp_saludos.png" alt="WhatsAPP Saludos" style="width:300px;height:90px;"></a>
            <br><br>
            <a href="https://wa.me/56962192999" target="_blank"><img class="app" src="img/wsp_comercial.png" alt="WhatsAPP Comercual" style="width:300px;height:90px;"></a>
            <br>            
        </div>
        <hr>
        <footer class="pie-sitio">
            <div class="info-comercial">
                    <h1 style="font-family:Tahoma;font-size:20px;">Información Comercial</h1>
                    <p>Whatsapp <a href="https://wa.me/56962192999">+56962192999</a></p>
                    <p>E-Mail <a href="mailto:ventas@lasabrositafm.cl">ventas@lasabrositafm.cl</a></p>
                    <p>Sitio ajustado por <a href="https://vypstudios.cl">Victor Flores</a></p>
            </div>
        </footer>  
        </center>
    </body>
</html>